#include <msp430.h> 
#include "TLC6983DMA.h"
#include "TLC6983.h"
#include "CCSI_Socket.h"
#include "delayTimer.h"

#define CPU_F ((double)3000000)
#define delay_ms(x) __delay_cycles((long)(CPU_F*(double)x/1000.0))
#define delay_us(x) __delay_cycles((long)(CPU_F*(double)x/1000000.0))

const uint8_t SINGLE_SCREEN = 16;
const uint8_t SCANLINE_NUM = 20;
const uint8_t CHANNEL_NUM = 16;
const uint8_t STACKED_UNITS = 2;

uint8_t count=0;
uint8_t dmaTxData[68]; //Stores the data bytes to be sent tlc6983dma.h/ccsi_so
uint8_t dmaRxData[18]; //Stores the data bytes to be received
const uint16_t img_R_IAC[32][32] = {
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,},
{0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,}
};
const uint16_t img_G_IAC[32][32] = {
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
{0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
};

unsigned int dmaSyncFlag; //timeout flag

/* Function Name: setData
 *
 * Purpose: Set data send buffer.
 *
 * Parameters:
 * data -> The pointer of data send buffer.
 * high, mid, low -> Data bytes, MSB first.
 * bias -> Bias in the date send buffer.
 *
 */
void setData(uint16_t *data, uint16_t high, uint16_t mid, uint16_t low, uint8_t bias){
    data[0 + bias] = high;
    data[1 + bias] = mid;
    data[2 + bias] = low;
}


void sendSRAMandSYNC_clear()
{
    uint16_t data[6] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00};//Data send buffer
    uint8_t k = 0;
    uint8_t i = 0;
    uint8_t j = 0;

    for(i = 0 ; i < 20 ; i++){
        for(j = 0 ; j < 16 ; j++){
                setData(data, 0x0000,0x0000,0x0000,0);
                setData(data, 0x0000,0x0000,0x0000,3);
        }
    }
    delay_us(1000);
    // For any repeat need to SYNC to keep displaying the frame
    CCSI_write(W_VSYNC, data, 0);
}

/**
 * main.c
 */
int main(void)
 {
    uint16_t data[6] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00};//Data send buffer
    uint8_t y_dir = 0; //Loop index
    uint8_t x_dir = 0;
    uint8_t k = 0;

    WDTCTL = WDTPW | WDTHOLD;   // stop watchdog timer
    
    __bic_SR_register(GIE); //enable interrupt
    ucsInitial(); //system clock initial
    timerInitial(); //
    spiInitial();
    dmaInitial();
    
    CCSI_write(W_CHIP_INDEX, data, 0);//Write chip index.
    CCSI_write(W_CHIP_INDEX, data, 0);//Write chip index.
    
    setData(data, 0x9001, 0xE073, 0x8101, 0);//16x 4MHz= 40Mhz, 64 sub-periods, totally xxms, about 50Hz
    CCSI_write(W_FC0, data, 3);
    
    setData(data, 0x0085, 0xE252, 0x97F0, 0);
    CCSI_write(W_FC1, data, 3);
    
    setData(data, 0x0000, 0x0000, 0x0980, 0);//
    CCSI_write(W_FC2, data, 3);
    
    setData(data, 0x0013, 0x4055, 0x8f80, 0);//
    CCSI_write(W_FC3, data, 3);
    
    setData(data, 0x17F8, 0x0540, 0x4009, 0);//
    CCSI_write(W_FC4, data, 3);
    
    // Send black frame to LED Driver SRAM and SYNC
    sendSRAMandSYNC_clear();
    
    while(1){
        //line fade function
        for(count = 0 ; count < SCANLINE_NUM + 1 ; count++){
        for(y_dir = 0 ; y_dir < SCANLINE_NUM ; y_dir++){
            for(x_dir = 0 ; x_dir < CHANNEL_NUM ; x_dir++){
                for(k = 0; k < STACKED_UNITS; k++){
                    if (y_dir < count)
                    setData(data, 0x0000, 0x0000, 0x0000, k * 3);
                    else
                    setData(data,
                            0x0000,
                            img_G_IAC[y_dir][x_dir * 2 + k],
                            img_R_IAC[y_dir][x_dir * 2 + k],
                            k * 3);
                }
                CCSI_write(W_SRAM, data, STACKED_UNITS * 3);
            }
        }
        delay_ms(5);
        // For any repeat need to SYNC to keep displaying the frame
        CCSI_write(W_VSYNC, data, 0);
        //delay_ms(1);
        }

        //channel fade function
        for(count = 0 ; count <  14 ; count++){
        for(y_dir = 0 ; y_dir < SCANLINE_NUM ; y_dir++){
            for(x_dir = 0 ; x_dir < CHANNEL_NUM ; x_dir++){
                for(k = 0; k < STACKED_UNITS; k++){
                    if (x_dir < count)
                    setData(data, 0x0000, 0x0000, 0x0000, k * 3);
                    else
                    setData(data,
                            0x0000,
                            img_G_IAC[y_dir][x_dir * 2 + k],
                            img_R_IAC[y_dir][x_dir * 2 + k],
                            k * 3);
                }
                CCSI_write(W_SRAM, data, STACKED_UNITS * 3);
            }
        }
        // For any repeat need to SYNC to keep displaying the frame
        CCSI_write(W_VSYNC, data, 0);
        }

    }
    

    return 0;
}
